/*\file InputDuplicate.c
 *\brief: duplicate input
 */

#include "./InputDuplicate.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	int      original_enum,new_enum; 

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputDuplicateUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTS);
	FetchMatlabData((DataSet**)&nodes,NODES);
	FetchMatlabData((DataSet**)&vertices,VERTICES);
	FetchMatlabData((DataSet**)&loads,LOADS);
	FetchMatlabData((DataSet**)&materials,MATERIALS);
	FetchMatlabData(&parameters,PARAMETERS);
	
	FetchMatlabData(&original_enum,ORIGINALENUM);
	FetchMatlabData(&new_enum,NEWENUM);

	/*!Call core code: */
	InputDuplicatex( elements, nodes, vertices, loads, materials,parameters,original_enum, new_enum);

	/*write output : */
	WriteMatlabData(ELEMENTSOUT,elements);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	/*end module: */
	MODULEEND();

}

void InputDuplicateUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [elements] = %s(elements, nodes, vertices, loads, materials, parameters, original_enum,new_enum);\n",__FUNCT__);
	_printf_(true,"\n");
}
