/*\file CostFunction.c
 *\brief: compute misfit between modeled velocity and observed velocity
 */

#include "./CostFunction.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements   *elements   = NULL;
	Loads      *loads      = NULL;
	Nodes      *nodes      = NULL;
	Vertices   *vertices   = NULL;
	Materials  *materials  = NULL;
	Parameters *parameters = NULL;

	/* output datasets: */
	double J;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&CostFunctionUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTS);
	FetchMatlabData((DataSet**)&nodes,NODES);
	FetchMatlabData((DataSet**)&vertices,VERTICES);
	FetchMatlabData((DataSet**)&loads,LOADS);
	FetchMatlabData((DataSet**)&materials,MATERIALS);
	FetchMatlabData(&parameters,PARAMETERS);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Call core code: */
	CostFunctionx(&J, elements,nodes,vertices, loads,materials,parameters);

	/*write output : */
	WriteMatlabData(COST,J);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void CostFunctionUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [J] = %s(elements,nodes,vertices,loads, materials, parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
