function	[Xedge,Yedge,EdgeValues]=CreateDataBoundaries(x_m,y_m,x_matrix,y_matrix,datamatrix);
%CREATEDATABOUNDARIES - Create values on the edge of the matrix
%
%   This function create vectors with coordinates and values to constrain a matrix 
%   on its edge from a given matrix tiwh data everywhere.
%   x_m and y_m belongs to the matrix to be constrained
%   x_matrix, y_matrix belongs to the matrix to be constrained with
%   datamatrix is the matrix with values for the constraint
%
%   Usage:
%      [Xedge,Yedge,EdgeValues]=CreateDataBoundaries(x_m,y_m,x_matrix,y_matrix,datamatrix);
% 
%   See also: TRACKSTOMATRIX, CREATEDATAMATRIX

%Check the consistency of the data matrix
if(length(x_matrix)~=(size(datamatrix,2)+1) | length(y_matrix)~=(size(datamatrix,1)+1)),
	error('CreateDataBoundaries error message: size of matrix and vectors to constrained not consistent')
end

nxglobal=length(x_m);
nyglobal=length(y_m);

%Create the edgevalues and coordinates
xedge1=x_m(1)*ones(nyglobal,1);
xedge2=x_m(2:end-1);
xedge3=x_m(end)*ones(nyglobal,1);
xedge4=x_m(2:end-1);
xedge5=x_m(2)*ones(nyglobal-2,1);
xedge6=x_m(3:end-2);
xedge7=x_m(end-1)*ones(nyglobal-2,1);
xedge8=x_m(3:end-2);
yedge1=y_m;
yedge2=y_m(1)*ones(nxglobal-2,1);
yedge3=y_m;
yedge4=y_m(end)*ones(nxglobal-2,1);
yedge5=y_m(2:end-1);
yedge6=y_m(2)*ones(nxglobal-4,1);
yedge7=y_m(2:end-1);
yedge8=y_m(end-1)*ones(nxglobal-4,1);

Xedge=[xedge1;xedge2;xedge3;xedge4;xedge5;xedge6;xedge7;xedge8];
Yedge=[yedge1;yedge2;yedge3;yedge4;yedge5;yedge6;yedge7;yedge8];
EdgeValues=DataInterp(x_matrix,y_matrix,datamatrix,Xedge,Yedge);
