function converged=steadystateconvergence(femmodel),
%STEADYSTATECONVERGENCE - determine convergence of steady state solution
% 
%   Usage:
%      steadystateconvergence(femmodel)
	
	converged=false;
	velocity_convergence=false;
	temperature_convergence=false;

	%Retrieve parameters
	convergencecriterionvalue=femmodel.parameters.SteadystateReltol;
	velocityenums=[VxEnum;VxPicardEnum;VyEnum;VyPicardEnum;VzEnum;VzPicardEnum;PressureEnum;PressurePicardEnum]; %pairs of enums (new and old) on which to carry out the converence tests
	temperatureenums=[TemperatureEnum;TemperatureOldEnum];
	convergencecriterion=[RelativeEnum]; %criterions for convergence, RelativeEnum or AbsoluteEnum 

	%Figure out convergence at the input level, because we don't have the solution vectors
	velocity_convergence=InputConvergence(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,velocityenums,convergencecriterion,convergencecriterionvalue);
	temperature_convergence=InputConvergence(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,temperatureenums,convergencecriterion,convergencecriterionvalue);

	if (velocity_convergence & temperature_convergence),
		converged=true;
	end
