%SURFACEFORCING Class definition
%
%   Usage:
%      surfaceforcings=surfaceforcings();

classdef surfaceforcings
	properties (SetAccess=public) 
		accumulation_rate = NaN;
		ablation_rate     = NaN;
		mass_balance      = NaN;
	end
	methods
		function obj = surfaceforcings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(PrognosticAnalysisEnum,analyses),
				checkfield(md,'surfaceforcings.mass_balance','forcing',1,'NaN',1);
			end
			if ismember(BalancethicknessAnalysisEnum,analyses),
				checkfield(md,'surfaceforcings.mass_balance','size',[md.mesh.numberofvertices 1],'NaN',1);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   surface forcings parameters:'));

			fielddisplay(obj,'accumulation_rate','surface accumulation rate [m]');
			fielddisplay(obj,'ablation_rate','surface ablation rate [m]');
			fielddisplay(obj,'mass_balance','surface mass balance [m]');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','accumulation_rate','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','ablation_rate','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','mass_balance','format','DoubleMat','mattype',1);
		end % }}}
	end
end
