function options = pairoptions(varargin),
%PAIROPTIONS - constructor for pairoptions object
%
%   Usage:
%      pairoptions = pairoptions

%check length of input
if mod(nargin,2)==1,
	error('pairoption error message: an even number of options is required')
end

%get calling function name
a=dbstack;
if length(a)>1,
	functionname=a(2).file(1:end-2);
else
	functionname='';
end

%create a pairoption object
if nargin==0,

	options.list=cell(0,2);
	options.type=functionname;
	options=class(options,'pairoptions');

else

	options.list=cell(0,2);
	options.type=functionname;
	options=class(options,'pairoptions');

	%initialize list
	options=buildlist(options,varargin{:});

end
