function pairoptions=deleteduplicates(pairoptions,warn)
%DELETEDUPLICATES - delete duplicates in an option list
%
%   Usage:
%      pairoptions=deleteduplicates(pairoptions,warn)
%
%   if warn==1 display an info message to wan user that
%   some of his options have been removed.

%track the first occurance of each option
[dummy lines]=unique(pairoptions.list(:,1),'first');
clear dummy

%warn user if requested
if warn,
	numoptions=size(pairoptions.list,1);
	for i=1:numoptions,
		if ~ismember(i,lines),
			disp(['deleteduplicates info: option ' pairoptions.list{i,1} ' appeared more than once. Only its first occurence will be kept'])
		end
	end
end

%remove duplicates from the options list
pairoptions.list=pairoptions.list(lines,:);
