function pairoptions=changefieldvalue(pairoptions,field,newvalue)
%CHANGEOPTIONVALUE - change the value of an option in an option list
%
%   Usage:
%      pairoptions=changefieldvalue(pairoptions,field,newvalue)
%
%   the value associated with all the fields equal to the one given in
%   input will be modified. If no field is foud, the field will be to
%   the option list added

%track occurance of field
lines=find(strcmpi(pairoptions.list(:,1),field));

%replace value
if isempty(lines),
	%add new field if not found
	pairoptions=addfield(pairoptions,field,newvalue);
else
	for i=1:length(lines),
		pairoptions.list{lines(i),2}=newvalue;
	end
end
