/*\file petscpatches.h
 * \brief: our own patches for petsc use
 */

#ifndef _PETSC_PATCHES_H_
#define _PETSC_PATCHES_H_

#include "petscmat.h"
#include "petscvec.h"
#include "petscksp.h"
#include "petscsys.h"

#include "./SolverEnum.h"

class Parameters;

#ifdef _SERIAL_
#include "mex.h"
int MatlabMatrixToPetscMatrix(Mat* matrix,int* prows,int* pcols, const mxArray* mxmatrix);
int MatlabVectorToPetscVector(Vec* pvector,int* pvector_rows,const mxArray* mxvector);
int PetscMatrixToMatlabMatrix(mxArray** pdataref,Mat matrix);
int PetscVectorToMatlabVector(mxArray** pdataref,Vec vector);
int MatlabMatrixToDoubleMatrix(double** pmatrix,int* pmatrix_rows,int* pmatrix_cols,const mxArray* mxmatrix);
int MatlabVectorToDoubleVector(double** pvector,int* pvector_rows,const mxArray* mxvector);
#endif

int PetscDetermineLocalSize(int global_size);
Vec NewVec(int size,bool fromlocalsize=false);
Mat NewMat(int M,int N);
Mat NewMat(int M,int N,double sparsity);
Mat NewMat(int M,int N,int connectivity,int numberofdofspernode);

int VecTranspose(Vec* tvector,Vec vector);
int VecToMPISerial(double** pgathered_vector, Vec vector);
void GetOwnershipBoundariesFromRange(int* plower_row,int* pupper_row,int range);
void MatFree(Mat* pmat);
void ISFree(IS* pis);
void VecFree(Vec* pvec);
void KSPFree(KSP* pksp);
void VecPartition(Vec* poutvector,Vec vectorA, double* row_partition_vector, int row_partition_vector_size,bool kffpartitioning);
int MatPartition(Mat* poutmatrix,Mat matrixA,double* row_partition_vector,int row_partition_vector_size ,
		double* col_partition_vector,int col_partition_vector_size);
void MatInvert(Mat* pInv, Mat Matrix);
void PetscOptionsInsertMultipleString(char* options_string);
void PetscOptionsDetermineSolverType(int* psolver_type);
void VecMerge(Vec A, Vec B, double* row_partition_vector,int row_partition_size);
void MatMultPatch(Mat A,Vec X, Vec AX);
void MatToSerial(double** poutmatrix,Mat matrix);
void VecDuplicatePatch(Vec* output, Vec input);
Vec  SerialToVec(double* vector,int vector_size);

#endif
