/*!\file:  trimesh.h
 * \brief
 */ 

#ifndef _SHARED_TRIMESH_H
#define _SHARED_TRIMESH_H


#include <stdio.h>
#include <math.h>



//#define REAL double //took  it out because it may conflict with stdlib.h defines. put back if necessary

int AssociateSegmentToElement(double** psegments,int nseg, double* index,int nel);
int OrderSegments(double** psegments,int nseg, double* index,int nel);
		
int GridInsideHole(double* px0,double* py0,int n,double* x,double* y);
int FindElement(double A,double B,double* index,int nel);

int SplitMeshForRifts(int* pnel,double** pindex,int* pnods,double** px,double** py,int* pnsegs,double** psegments,double** psegmentmarkerlist);

int IsGridOnRift(int* riftsegments, int nriftsegs, int node);
int GridElementsList(int** pGridElements, int* pNumGridElements,int node,double * index,int nel);
int IsNeighbor(int el1,int el2,double* index);
int IsOnRift(int el,int nriftsegs,int* riftsegments);
int RiftSegmentsFromSegments(int* pnriftsegs, int** priftsegments, int nel, double* index, int nsegs,double* segments);
int DetermineGridElementListOnOneSideOfRift(int* pNumGridElementListOnOneSideOfRift, int** pGridElementListOnOneSideOfRift, int segmentnumber, int nriftsegs, int* riftsegments, int node,double* index,int nel);
int UpdateSegments(double** psegments,double** psegmentmarkerlist, int* pnsegs, double* index, double* x,double* y,int* riftsegments,int nriftsegs);
int pnpoly(int npol, double *xp, double *yp, double x, double y);
int FindElement(double A,double B,double* index,int nel);
int RemoveRifts(double** pindex,double** px,double** py,int* pnods,double** psegments,int* pnumsegs,int numrifts1,int* rifts1numsegs,double** rifts1segments,double** rifts1pairs,int nel);
int IsRiftPresent(int* priftflag,int* pnumrifts, double* segmentmarkerlist,int nsegs);
int SplitRiftSegments(double** psegments,double** psegmentmarkerlist, int* pnumsegs, int* pnumrifts,int** priftsnumsegs,double*** priftssegments,int numrifts);
int OrderRifts(double** priftstips, double** riftssegments,double** riftspairs,int numrifts,int* riftsnumsegments,double* x,double* y);
int PenaltyPairs(double*** priftspenaltypairs,int** priftsnumpenaltypairs,int numrifts,double**  riftssegments,
		int* riftsnumsegments,double** riftspairs,double* riftstips,double* x,double* y);

int RemoveCornersFromRifts(double** pindex,int* pnel,double** px,double** py,int* pnods, double* segments,double* segmentmarkers,int num_seg);
int PairRiftElements(int** priftsnumpairs, double*** priftspairs,int numrifts,int* riftsnumsegments, double** riftssegments,double* x,double* y);


#endif  /* _SHARED_TRIMESH_H */
