/*!\file:  TransformInvStiffnessMatrixCoord.cpp
 * \brief transform stiffness matrix inverse coordinate system
 */ 
#include "./elements.h"

void TransformInvStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int cs_enum){

	int* cs_array=NULL;

	/*All nodes have the same Coordinate System*/
	cs_array=(int*)xmalloc(numnodes*sizeof(int));
	for(int i=0;i<numnodes;i++) cs_array[i]=cs_enum;

	/*Call core*/
	TransformInvStiffnessMatrixCoord(Ke,nodes,numnodes,cs_array);

	/*Clean-up*/
	xfree((void**)&cs_array);
}

void TransformInvStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int* cs_array){

	int     i,j;
	int     numdofs   = 0;
	double *transform = NULL;
	double *values    = NULL;

	/*Get total number of dofs*/
	for(i=0;i<numnodes;i++){
		switch(cs_array[i]){
			case XYEnum:   numdofs+=2; break;
			case XYZPEnum: numdofs+=4; break;
			default: _error_("Coordinate system %s not supported yet",EnumToStringx(cs_array[i]));
		}
	}

	/*Copy current stiffness matrix*/
	values=(double*)xmalloc(Ke->nrows*Ke->ncols*sizeof(double));
	for(i=0;i<Ke->nrows;i++) for(j=0;j<Ke->ncols;j++) values[i*Ke->ncols+j]=Ke->values[i*Ke->ncols+j];

	/*Get Coordinate Systems transform matrix*/
	CoordinateSystemTransform(&transform,nodes,numnodes,cs_array);

	/*Transform matrix: R*Ke*R^T */
	TripleMultiply(transform,numdofs,numdofs,0,
				values,Ke->nrows,Ke->ncols,0,
				transform,numdofs,numdofs,1,
				&Ke->values[0],0);

	/*Free Matrix*/
	xfree((void**)&transform);
	xfree((void**)&values);
}
