/*! \file OptionDouble.h 
 *  \brief: header file for optiondouble object
 */

#ifndef _OPTIONDOUBLE_H_
#define _OPTIONDOUBLE_H_

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./Option.h"
/*}}}*/

class OptionDouble: public Option {

	public:

		double* values;

		/*OptionDouble constructors, destructors {{{1*/
		OptionDouble();
		~OptionDouble();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		int   Id(){_error_("Not implemented yet");};
		int   MyRank(){_error_("Not implemented yet");};
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset){_error_("Not implemented yet");};
		int   MarshallSize(){_error_("Not implemented yet");};
		void  Demarshall(char** pmarshalled_dataset){_error_("Not implemented yet");};
		#endif
		int   ObjectEnum(){return OptionDoubleEnum;};
		Object* copy(){_error_("Not implemented yet");};
		/*}}}*/

		/*virtual functions: */
		char* Name();
		int   NumEl();
		int   NDims();
		int*  Size();
		void  Get(double* pvalue);
		void  Get(bool* pvalue){  _error_("An OptionDouble object cannot return a bool");};
		void  Get(char** pvalue){ _error_("An OptionDouble object cannot return a string");};
		void  Get(char*** ppvalue,int *pnumel){ _error_("An OptionDouble object cannot return a string vec");};
		void  Get(double** pvalue,int* pnumel);
		void  Get(Options** pvalue){ _error_("An OptionDouble object cannot return an Options DataSet");};
		void  Get(Options*** ppvalue,int *pnumel){ _error_("An OptionDouble object cannot return an Options DataSet vec");};

};
#endif  /* _OPTIONDOUBLE_H */

