/*! \file DoubleElementResult.h 
 *  \brief: header file for double result object
 *  A double result object is just derived from a DoubleInput object, with additional time and step information.
 */


#ifndef _DOUBLEELEMENTRESULT_H_
#define _DOUBLEELEMENTRESULT_H_

/*Headers:*/
/*{{{1*/
#include "../Inputs/Input.h"
#include "../../include/include.h"
class Parameters;
/*}}}*/

class DoubleElementResult: public ElementResult{

	private: 
		int    enum_type;
		double value;
		int    step;
		double time;

	public:

		/*DoubleElementResult constructors, destructors: {{{1*/
		DoubleElementResult();
		DoubleElementResult(int enum_type,double value,int step,double time);
		~DoubleElementResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ElementResult virtual functions definitions: {{{1*/
		ElementResult* SpawnTriaElementResult(int* indices);
		double  GetTime(void){return time;};
		int     GetStep(void){return step;};
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/
		/*DoubleElementResult management: {{{1*/
		int   InstanceEnum();
		void GetVectorFromResults(Vec vector,int* doflist,int* connectivitylist,int numdofs){_error_("not implemented");};
		void GetElementVectorFromResults(Vec vector,int dof){_error_("not implemented");};
		/*}}}*/
};
#endif  /* _DOUBLEELEMENTRESULT_H */
