/*!\file: DofIndexing.h
 * \brief prototype for DofIndexing.h
 */ 

#ifndef _DOFINDEXING_H_
#define  _DOFINDEXING_H_

class DofIndexing{
	
	public:

		/*sizes: */
		int gsize; //number of dofs for a node
		int fsize; //number of dofs solver for
		int ssize; //number of constrained dofs

		/*partitioning: */
		int     clone;   //this node is replicated from another one 

		/*boundary conditions sets: */
		bool*     f_set; //is dof on f-set (on which we solve)
		bool*     s_set; //is dof on s-set (on which boundary conditions -dirichlet- are applied)
		double*   svalues; //list of constraint values. size g_size, for ease of use.

		/*types of dofs: */
		int*     doftype; //approximation type of the dofs (used only for coupling), size g_size
		
		/*list of degrees of freedom: */
		int*     gdoflist; //dof list in g_set
		int*     fdoflist; //dof list in f_set
		int*     sdoflist; //dof list in s_set


		/*DofIndexing constructors, destructors {{{1*/
		DofIndexing();
		DofIndexing(int g_size);
		void Init(int g_size,int* doftype);
		void InitSet(int setenum);
		DofIndexing(DofIndexing* properties);
		~DofIndexing();
		/*}}}*/
		/*Object like functionality: {{{1*/
		void  Echo(void); 
		void  DeepEcho(void); 
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		void  copy(DofIndexing* properties);
		/*}}}*/
		/*DofIndexing management: {{{1*/
		DofIndexing* Spawn(int* indices, int numindices);
		/*}}}*/

};
#endif //ifndef _DOFINDEXING_H_
