/*!\file InputUpdateFromSolutionx
 * \brief: update datasets using  parameter inputs
 */

#include "./InputUpdateFromSolutionx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void InputUpdateFromSolutionx( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,Vec solution){

	double* serial_solution=NULL;

	/*Serialize solution, so that elements can index into it on every CPU: */
	VecToMPISerial(&serial_solution,solution);

	/*Call overloaded form of InputUpdateFromSolutionx: */
	InputUpdateFromSolutionx( elements, nodes,  vertices,  loads,  materials,  parameters,serial_solution);

	/*Free ressources:*/
	xfree((void**)&serial_solution);

}


void InputUpdateFromSolutionx( Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,double* solution){

	/*Intermediary*/
	int i;
	Element* element=NULL;

	/*Elements drive the update: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->InputUpdateFromSolution(solution);
	}

}
