/*!\file IceVolumex
 * \brief: compute total ice volume
 */

#include "./IceVolumex.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void IceVolumex(double* pV, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){

	double local_ice_volume = 0;
	double total_ice_volume;

	for(int i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		local_ice_volume+=element->IceVolume();
	}
	MPI_Reduce(&local_ice_volume,&total_ice_volume,1,MPI_DOUBLE,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&total_ice_volume,1,MPI_DOUBLE,0,MPI_COMM_WORLD);

	/*Assign output pointers: */
	*pV=total_ice_volume;
}
