%This test is a test from the ISMP-HOM Intercomparison project
%Pattyn and Payne 2006

L_list={5000,10000,20000,40000,80000,160000};
results={};

for i=1:length(L_list),
	L=L_list{i};
	nx=20; %numberof nodes in x direction
	ny=20;
	md=model;
	md=squaremesh(md,L,L,nx,ny);
	md=setmask(md,'',''); %ice sheet test
	md=parameterize(md,'../Par/ISMIPB.par');
	md=extrude(md,10,1);
	md=setflowequation(md,'pattyn','all');

	%Create dirichlet on the bed only
	md.diagnostic.spcvx=NaN*ones(md.mesh.numberofvertices,1);
	md.diagnostic.spcvy=NaN*ones(md.mesh.numberofvertices,1);
	md.diagnostic.spcvz=NaN*ones(md.mesh.numberofvertices,1);

	pos=find(md.mesh.vertexonbed);
	md.diagnostic.spcvx(pos)=0;
	md.diagnostic.spcvy(pos)=0;

	%Create MPCs to have periodic boundary conditions
	posx=find(md.mesh.x==0);
	posx2=find(md.mesh.x==max(md.mesh.x));

	posy=find(md.mesh.y==0 & md.mesh.x~=0 & md.mesh.x~=max(md.mesh.x)); %Don't take the same nodes two times
	posy2=find(md.mesh.y==max(md.mesh.y) & md.mesh.x~=0 & md.mesh.x~=max(md.mesh.x));

	md.diagnostic.vertex_pairing=[posx,posx2;posy,posy2];

	%Compute the diagnostic
	md.diagnostic.abstol=NaN;
	md.cluster=generic('name',oshostname(),'np',8);
	md=solve(md,DiagnosticSolutionEnum);
	pos=find(md.mesh.x==0 | md.mesh.y==0 | md.mesh.x==max(md.mesh.x) | md.mesh.y==max(md.mesh.y));
	md.diagnostic.spcvx(pos)=md.results.DiagnosticSolution.Vx(pos);
	md.diagnostic.spcvy(pos)=md.results.DiagnosticSolution.Vy(pos);
	md.diagnostic.vertex_pairing=[];
	md=setflowequation(md,'stokes','all');
	md=solve(md,DiagnosticSolutionEnum);

	%Plot the results and save them
	vx=(md.results.DiagnosticSolution.Vx);
	vy=(md.results.DiagnosticSolution.Vy);
	vz=(md.results.DiagnosticSolution.Vz);
	results{i}=md.results.DiagnosticSolution;

	plotmodel(md,'data',vx,'data',vy,'data',vz,'layer#all',md.mesh.numberoflayers)
end

%Fields and tolerances to track changes
field_names     ={...
	'Vx5km','Vy5km','Vz5km',...
	'Vx10km','Vy10km','Vz10km',...
	'Vx20km','Vy20km','Vz20km',...
	'Vx40km','Vy40km','Vz40km',...
	'Vx80km','Vy80km','Vz80km',...
	'Vx160km','Vy160km','Vz160km'
};
field_tolerances={...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
	1e-07,1e-07,1e-07,...
};
field_values={};
for i=1:6,
	result=results{i};
	field_values={field_values{:},...
		(result.Vx),...
		(result.Vy),...
		(result.Vz),...
		};
end
