/*!\file KML_File.cpp
 * \brief: implementation of the kml_file object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_File::KML_File(){{{1*/
KML_File::KML_File(){

	kmlobj    =new DataSet;

}
/*}}}*/
/*FUNCTION KML_File::~KML_File(){{{1*/
KML_File::~KML_File(){

	if (kmlobj) {
		delete kmlobj;
		kmlobj    =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_File::Echo {{{1*/
void  KML_File::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_File:\n");
	KML_Object::Echo();

	_printf_(flag,"        kmlobj: (size=%d)\n" ,kmlobj->Size());

	return;
}
/*}}}*/
/*FUNCTION KML_File::DeepEcho {{{1*/
void  KML_File::DeepEcho(){

	char  indent[81]="";

	KML_File::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION KML_File::DeepEcho {{{1*/
void  KML_File::DeepEcho(const char* indent){

	int   i;
	char  indent2[81];
	bool  flag=true;

	_printf_(flag,"%sKML_File:\n",indent);
	KML_Object::DeepEcho(indent);

/*  loop over the kml objects for the file  */

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));
	strcat(indent2,"  ");

	if (kmlobj->Size())
		for (i=0; i<kmlobj->Size(); i++) {
			_printf_(flag,"%s        kmlobj: -------- begin [%d] --------\n" ,indent,i);
			((KML_Object *)kmlobj->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s        kmlobj: --------  end  [%d] --------\n" ,indent,i);
		}
	else
		_printf_(flag,"%s        kmlobj: [empty]\n"    ,indent);

	return;
}
/*}}}*/
/*FUNCTION KML_File::Write {{{1*/
void  KML_File::Write(FILE* filout,const char* indent){

	int   i;
	char  indent2[81];

	fprintf(filout,"%s<kml",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");
	WriteCommnt(filout,indent);

	KML_Object::Write(filout,indent);

/*  loop over the kml objects for the file  */

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

	for (i=0; i<kmlobj->Size(); i++)
		((KML_Object *)kmlobj->GetObjectByOffset(i))->Write(filout,indent2);

	fprintf(filout,"%s</kml>\n",indent);

	return;
}
/*}}}*/
/*FUNCTION KML_File::Read {{{1*/
void  KML_File::Read(FILE* fid,char* kstr){

	char*        kstri;
	int          ncom=0;
	char**       pcom=NULL;
	KML_Object*  kobj;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid,
							  &ncom,&pcom)) {
		if      (!strncmp(kstri,"</kml", 5)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_File::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_File::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strncmp(kstri,"<Placemark",10)) {
			kobj=(KML_Object*)new KML_Placemark();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<Folder", 7)) {
			kobj=(KML_Object*)new KML_Folder();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<Document", 9)) {
			kobj=(KML_Object*)new KML_Document();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<GroundOverlay",14)) {
			kobj=(KML_Object*)new KML_GroundOverlay();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<LatLonBox",10)) {
			kobj=(KML_Object*)new KML_LatLonBox();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<Icon", 5)) {
			kobj=(KML_Object*)new KML_Icon();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<Point", 6)) {
			kobj=(KML_Object*)new KML_Point();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<LineString",11)) {
			kobj=(KML_Object*)new KML_LineString();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<LinearRing",11)) {
			kobj=(KML_Object*)new KML_LinearRing();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<Polygon", 8)) {
			kobj=(KML_Object*)new KML_Polygon();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<MultiGeometry",14)) {
			kobj=(KML_Object*)new KML_MultiGeometry();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

//		else if (!strncmp(kstri,"<IconStyle",10)) {
//			kobj=(KML_Object*)new KML_IconStyle();
//			kobj->Read(fid,kstri);
//			kmlobj    ->AddObject((Object*)kobj);
//		}

//		else if (!strncmp(kstri,"<LabelStyle",11)) {
//			kobj=(KML_Object*)new KML_LabelStyle();
//			kobj->Read(fid,kstri);
//			kmlobj    ->AddObject((Object*)kobj);
//		}

		else if (!strncmp(kstri,"<LineStyle",10)) {
			kobj=(KML_Object*)new KML_LineStyle();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<PolyStyle",10)) {
			kobj=(KML_Object*)new KML_PolyStyle();
			kobj->Read(fid,kstri);
			kmlobj    ->AddObject((Object*)kobj);
		}

//		else if (!strncmp(kstri,"<BalloonStyle",13)) {
//			kobj=(KML_Object*)new KML_BalloonStyle();
//			kobj->Read(fid,kstri);
//			kmlobj    ->AddObject((Object*)kobj);
//		}

//		else if (!strncmp(kstri,"<ListStyle",10)) {
//			kobj=(KML_Object*)new KML_ListStyle();
//			kobj->Read(fid,kstri);
//			kmlobj    ->AddObject((Object*)kobj);
//		}

		else if (!strncmp(kstri,"<",1))
			KML_Object::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	this->AddCommnt(ncom,pcom);

	for (ncom; ncom>0; ncom--)
		xfree((void**)&(pcom[ncom-1]));
	xfree((void**)&pcom);

	return;
}
/*}}}*/
/*FUNCTION KML_File::WriteExp {{{1*/
void  KML_File::WriteExp(FILE* fid,const char* nstr,int sgn,double cm,double sp){

	int   i;

/*  loop over the kml objects for the file  */

	for (i=0; i<kmlobj->Size(); i++)
		((KML_Object *)kmlobj->GetObjectByOffset(i))->WriteExp(fid,nstr,sgn,cm,sp);

	return;
}
/*}}}*/
