/*!\file KML_Feature.cpp
 * \brief: implementation of the kml_feature abstract object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Feature::KML_Feature(){{{1*/
KML_Feature::KML_Feature(){

	memcpy(name,"",(strlen("")+1)*sizeof(char));

	visibility=true;
	open      =false;
	memcpy(snippet,"",(strlen("")+1)*sizeof(char));
	memcpy(descript,"",(strlen("")+1)*sizeof(char));
	memcpy(styleurl,"",(strlen("")+1)*sizeof(char));
	style     =new DataSet;

}
/*}}}*/
/*FUNCTION KML_Feature::~KML_Feature(){{{1*/
KML_Feature::~KML_Feature(){

	if (style) {
		delete style;
		style     =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Feature::Echo {{{1*/
void  KML_Feature::Echo(){

	bool  flag=true;

	KML_Object::Echo();

	_printf_(flag,"          name: \"%s\"\n"    ,name);
	_printf_(flag,"    visibility: %s\n"        ,(visibility ? "true" : "false"));
	_printf_(flag,"          open: %s\n"        ,(open ? "true" : "false"));
	_printf_(flag,"       snippet: \"%s\"\n"    ,snippet);
	_printf_(flag,"      descript: \"%s\"\n"    ,descript);
	_printf_(flag,"      styleurl: \"%s\"\n"    ,styleurl);
	_printf_(flag,"         style: (size=%d)\n" ,style->Size());

	return;
}
/*}}}*/

/*FUNCTION KML_Feature::DeepEcho {{{1*/
void  KML_Feature::DeepEcho(){

	char  indent[81]="";

	KML_Feature::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Feature::DeepEcho {{{1*/
void  KML_Feature::DeepEcho(const char* indent){

	int   i;
	char  indent2[81];
	bool  flag=true;

	KML_Object::DeepEcho(indent);

	_printf_(flag,"%s          name: \"%s\"\n"      ,indent,name);
	_printf_(flag,"%s    visibility: %s\n"          ,indent,(visibility ? "true" : "false"));
	_printf_(flag,"%s          open: %s\n"          ,indent,(open ? "true" : "false"));
	_printf_(flag,"%s       snippet: \"%s\"\n"      ,indent,snippet);
	_printf_(flag,"%s      descript: \"%s\"\n"      ,indent,descript);
	_printf_(flag,"%s      styleurl: \"%s\"\n"      ,indent,styleurl);

/*  loop over any styles for the feature  */

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));
	strcat(indent2,"  ");

	if (style->Size())
		for (i=0; i<style->Size(); i++) {
			_printf_(flag,"%s         style: -------- begin [%d] --------\n" ,indent,i);
			((KML_Style *)style->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s         style: --------  end  [%d] --------\n" ,indent,i);
		}
	else
		_printf_(flag,"%s         style: [empty]\n"    ,indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Feature::Write {{{1*/
void  KML_Feature::Write(FILE* filout,const char* indent){

	int   i;
	char  indent2[81];

	KML_Object::Write(filout,indent);

	if (name     && strlen(name))
		fprintf(filout,"%s  <name>%s</name>\n",indent,name);
	fprintf(filout,"%s  <visibility>%d</visibility>\n",indent,(visibility ? 1 : 0));
	fprintf(filout,"%s  <open>%d</open>\n",indent,(open ? 1 : 0));
	if (snippet  && strlen(snippet))
		fprintf(filout,"%s  <Snippet maxLines=\"2\">%s</Snippet>\n",indent,snippet);
	if (descript && strlen(descript))
		fprintf(filout,"%s  <description>%s</description>\n",indent,descript);
	if (styleurl && strlen(styleurl))
		fprintf(filout,"%s  <styleUrl>%s</styleUrl>\n",indent,styleurl);

/*  loop over any styles for the feature  */

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

    for (i=0; i<style->Size(); i++)
        ((KML_Style *)style->GetObjectByOffset(i))->Write(filout,indent2);

	return;
}
/*}}}*/

/*FUNCTION KML_Feature::Read {{{1*/
void  KML_Feature::Read(FILE* fid,char* kstr){

	KML_Object*  kobj;

/*  process field within opening and closing tags  */

	if      (!strncmp(kstr,"</Feature", 9))
		return;
	else if (!strncmp(kstr,"</",2))
		_error_("KML_Feature::Read -- Unexpected closing tag %s.\n",kstr);
	else if (strncmp(kstr,"<",1))
		_error_("KML_Feature::Read -- Unexpected field \"%s\".\n",kstr);

	else if (!strncmp(kstr,"<Style", 6)) {
		kobj=(KML_Object*)new KML_Style();
		kobj->Read(fid,kstr);
		style     ->AddObject((Object*)kobj);
	}

	else if (!strcmp(kstr,"<name>"))
		KMLFileTokenParse( name      ,NULL,KML_FEATURE_NAME_LENGTH,
						  kstr,
						  fid);
	else if (!strcmp(kstr,"<visibility>"))
		KMLFileTokenParse(&visibility,
						  kstr,
						  fid);
	else if (!strcmp(kstr,"<open>"))
		KMLFileTokenParse(&open      ,
						  kstr,
						  fid);
	else if (!strncmp(kstr,"<snippet", 8))
		KMLFileTokenParse( snippet   ,NULL,KML_FEATURE_SNIPPET_LENGTH,
						  kstr,
						  fid);
	else if (!strcmp(kstr,"<description>"))
		KMLFileTokenParse( descript  ,NULL,KML_FEATURE_DESCRIPT_LENGTH,
						  kstr,
						  fid);
	else if (!strcmp(kstr,"<styleUrl>"))
		KMLFileTokenParse( styleurl  ,NULL,KML_FEATURE_STYLEURL_LENGTH,
						  kstr,
						  fid);

	else if (!strncmp(kstr,"<",1))
		KML_Object::Read(fid,kstr);

	return;
}
/*}}}*/

