/*\file ControlInputSetGradient.c
*\brief: update elements properties using an input  vector
*/

#include "./ControlInputSetGradient.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

/*input datasets: */
Elements   *elements   = NULL;
Nodes      *nodes      = NULL;
Vertices   *vertices   = NULL;
Loads      *loads      = NULL;
Materials  *materials  = NULL;
Parameters *parameters = NULL;
double     *gradient   = NULL;

/*Boot module: */
MODULEBOOT();

/*checks on arguments on the matlab side: */
CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ControlInputSetGradientUsage);

/*Input datasets: */
FetchMatlabData((DataSet**)&elements,ELEMENTSIN);
FetchMatlabData((DataSet**)&nodes,NODESIN);
FetchMatlabData((DataSet**)&vertices,VERTICESIN);
FetchMatlabData((DataSet**)&loads,LOADSIN);
FetchMatlabData((DataSet**)&materials,MATERIALSIN);
FetchMatlabData(&parameters,PARAMETERSIN);
FetchMatlabData(&gradient,NULL,GRADIENT);

/*configure: */
elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

/*call "x" code layer*/
ControlInputSetGradientx(elements,nodes,vertices,loads, materials,parameters,gradient);

/*write output datasets: */
WriteMatlabData(ELEMENTS,elements);
WriteMatlabData(NODES,nodes);
WriteMatlabData(VERTICES,vertices);
WriteMatlabData(LOADS,loads);
WriteMatlabData(MATERIALS,materials);
WriteMatlabData(PARAMETERS,parameters);

/*Free ressources: */
delete elements;
delete nodes;
delete vertices;
delete loads;
delete materials;
delete parameters;

/*end module: */
MODULEEND();
}

void ControlInputSetGradientUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [elements,nodes,vertices,loads,materials,parameters] = %s(elements,nodes,vertices,loads,materials,gradient);\n",__FUNCT__);
	_printf_(true,"\n");
}
