/*!\file ControlInputGetGradientx
 * \brief retrieve gradient from inputs in elements
 */

#include "./ControlInputGetGradientx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void ControlInputGetGradientx( Vec* pgradient, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters){

	/*Intermediaries*/
	int  num_controls;
	int *control_type = NULL;
	Vec  gradient=NULL;

	/*Retrieve some parameters*/
	parameters->FindParam(&num_controls,InversionNumControlParametersEnum);
	parameters->FindParam(&control_type,NULL,InversionControlParametersEnum);

	/*Allocate and populate gradient*/
	gradient=NewVec(num_controls*vertices->NumberOfVertices());

	for(int i=0;i<num_controls;i++){
		for(int j=0;j<elements->Size();j++){
			Element* element=(Element*)elements->GetObjectByOffset(j);
			element->ControlInputGetGradient(gradient,control_type[i],i);
		}
	}

	VecAssemblyBegin(gradient);
	VecAssemblyEnd(gradient);

	/*Clean up and return*/
	xfree((void**)&control_type);
	*pgradient=gradient;
}
