/*!\file Gradjx
 * \brief: compute inverse method gradient
 */

#include "./Gradjx.h"
#include "../modules.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void Gradjx( Vec* pgradient,double* pnorm_grad, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,int control_index){

	int    i;
	int    numberofvertices;
	double norm_grad;
	int   *control_type   = NULL;
	Vec    gradient = NULL;
	
	/*retrieve some parameters: */
	parameters->FindParam(&control_type,NULL,InversionControlParametersEnum);
	numberofvertices=vertices->NumberOfVertices();

	/*Allocate gradient: */
	gradient=NewVec(numberofvertices);

	/*Compute gradients: */
	for (i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->Gradj(gradient,control_type[control_index]);
	}

	/*Assemble vector: */
	VecAssemblyBegin(gradient);
	VecAssemblyEnd(gradient);

	/*Clean up and return*/
	xfree((void**)&control_type);
	if(pnorm_grad){
		VecNorm(gradient,NORM_INFINITY,&norm_grad);
		*pnorm_grad=norm_grad;
	}
	*pgradient=gradient;
}
