/*!\file: enthalpy_core_step.cpp
 * \brief: core of the enthalpy solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void enthalpy_core_step(FemModel* femmodel,int step, double time){
	
	bool modify_loads=true;

	_printf_(VerboseSolution(),"   computing enthalpy\n");
	femmodel->SetCurrentConfiguration(EnthalpyAnalysisEnum);
	solver_nonlinear(femmodel,modify_loads);

	/*transfer water column thickness to old water column thickness: */
	//InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,EnthalpyEnum,EnthalpyOldEnum);

}
