#include "petsc.h"
#include "petscfix.h"
#include "private/fortranimpl.h"
/* tao_util.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "tao.h"
#include "tao_util.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecpow_ VECPOW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecpow_ vecpow
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecmedian_ VECMEDIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecmedian_ vecmedian
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecfischer_ VECFISCHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecfischer_ vecfischer
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define vecsfischer_ VECSFISCHER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define vecsfischer_ vecsfischer
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define d_fischer_ D_FISCHER
#elif defined(FORTRANDOUBLEUNDERSCORE)
#define d_fischer_ d_fischer__
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
#define d_fischer_ d_fischer
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define d_sfischer_ D_SFISCHER
#elif defined(FORTRANDOUBLEUNDERSCORE)
#define d_sfischer_ d_sfischer__
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
#define d_sfischer_ d_sfischer
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  vecpow_(Vec v,PetscReal *p, int *__ierr ){
*__ierr = VecPow(
	(Vec)PetscToPointer((v) ),*p);
}
void PETSC_STDCALL  vecmedian_(Vec Vec1,Vec Vec2,Vec Vec3,Vec VMedian, int *__ierr ){
*__ierr = VecMedian(
	(Vec)PetscToPointer((Vec1) ),
	(Vec)PetscToPointer((Vec2) ),
	(Vec)PetscToPointer((Vec3) ),
	(Vec)PetscToPointer((VMedian) ));
}
void PETSC_STDCALL  vecfischer_(Vec X,Vec F,Vec L,Vec U,Vec FB, int *__ierr ){
*__ierr = VecFischer(
	(Vec)PetscToPointer((X) ),
	(Vec)PetscToPointer((F) ),
	(Vec)PetscToPointer((L) ),
	(Vec)PetscToPointer((U) ),
	(Vec)PetscToPointer((FB) ));
}
void PETSC_STDCALL  vecsfischer_(Vec X,Vec F,Vec L,Vec U,PetscReal *mu,Vec FB, int *__ierr ){
*__ierr = VecSFischer(
	(Vec)PetscToPointer((X) ),
	(Vec)PetscToPointer((F) ),
	(Vec)PetscToPointer((L) ),
	(Vec)PetscToPointer((U) ),*mu,
	(Vec)PetscToPointer((FB) ));
}
void PETSC_STDCALL  d_fischer_(Mat jac,Vec X,Vec Con,Vec XL,Vec XU,
        Vec T1,Vec T2,Vec Da,Vec Db, int *__ierr ){
*__ierr = D_Fischer(
	(Mat)PetscToPointer((jac) ),
	(Vec)PetscToPointer((X) ),
	(Vec)PetscToPointer((Con) ),
	(Vec)PetscToPointer((XL) ),
	(Vec)PetscToPointer((XU) ),
	(Vec)PetscToPointer((T1) ),
	(Vec)PetscToPointer((T2) ),
	(Vec)PetscToPointer((Da) ),
	(Vec)PetscToPointer((Db) ));
}
void PETSC_STDCALL  d_sfischer_(Mat jac,Vec X,Vec Con,
                       Vec XL,Vec XU,PetscReal *mu,
                       Vec T1,Vec T2,
                       Vec Da,Vec Db,Vec Dm, int *__ierr ){
*__ierr = D_SFischer(
	(Mat)PetscToPointer((jac) ),
	(Vec)PetscToPointer((X) ),
	(Vec)PetscToPointer((Con) ),
	(Vec)PetscToPointer((XL) ),
	(Vec)PetscToPointer((XU) ),*mu,
	(Vec)PetscToPointer((T1) ),
	(Vec)PetscToPointer((T2) ),
	(Vec)PetscToPointer((Da) ),
	(Vec)PetscToPointer((Db) ),
	(Vec)PetscToPointer((Dm) ));
}
#if defined(__cplusplus)
}
#endif
