/*!\file SmearFunctionx
 * \brief: create 
 */

#include "./SmearFunctionx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../io/io.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void SmearFunctionx(Vec* psmearedvector,double (*WeightFunction)(double distance,double radius), SmearedFieldEnum, double radius,Elements* elements,Nodes* nodes, Parameters* parameters){
	
	Element *element = NULL;
	Vec smearedvector=NULL;

	/*retrive parameters: */
	parameters->FindParam(&configuration_type,ConfigurationTypeEnum);

	
	/*allocate: */
	fsize=nodes->NumberOfDofs(configuration_type,FsetEnum);
	smearedvector=NewVec(fsize);

	/*Fill smearedvector vector: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->SmearFunction(smearedvector,WeightFunction,SmearedFieldEnum,radius);
	}


	VecAssemblyBegin(smearedvector);
	VecAssemblyEnd(smearedvector);
	
	/*Assign output pointers: */
	*psmearedvector=smearedvector;

}

