/*!\file UpdateVertexPositionsx
 * \brief update vertex positions using new geometry defined by new thickness and new bed.
 */

#include "./UpdateVertexPositionsx.h"
#include "../modules.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

int UpdateVertexPositionsx(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters){

	int     i;
	Vec     vz        = NULL;
	Vertex *vertex    = NULL;
	double *thickness = NULL;
	double *bed       = NULL;

	/*get vertex vectors for bed and thickness: */
	GetVectorFromInputsx(&thickness,elements,nodes, vertices, loads, materials, parameters, ThicknessEnum,VertexEnum);
	GetVectorFromInputsx(&bed      ,elements,nodes, vertices, loads, materials, parameters, BedEnum,      VertexEnum);

	/*Allocate vector*/
	vz=NewVec(vertices->NumberOfVertices());

	/*Update verices new geometry: */
	for (i=0;i<vertices->Size();i++){
		vertex=(Vertex*)vertices->GetObjectByOffset(i);
		vertex->UpdatePosition(vz,parameters,thickness,bed);
	}

	/*Assemble mesh velocity*/
	VecAssemblyBegin(vz);
	VecAssemblyEnd(vz);

	/*Free ressources:*/
	xfree((void**)&thickness);
	xfree((void**)&bed);
	VecFree(&vz);
	return 1;
}
