%Quick documentation for ISSM

%First get ISSM tier: 
ISSM_TIER=issmtier;

disp(sprintf('\n%s','  A comprehensive documentation is available on http://issm.jpl.nasa.gov'));
disp(sprintf('\n%s','  Example: how to create a square ice shelf'));
disp(sprintf(['  go to ' ISSM_TIER '/examples/SquareIceshelf\n']));
disp(sprintf('%-58s %s','   md=model;','%creates a new empty model structure'));
disp(sprintf('%-58s %s','   md=triangle(md,''DomainOutline.exp'',50000);','%creates a mesh of the domain outline with a resolution of 50000m'));
disp(sprintf('%-58s %s','   md=setmask(md,''all'','''');','%defines the glacier system as an ice shelf (no island)'));
disp(sprintf('%-58s %s','   md=parameterize(md,''Square.par'');','%fills all the other fields of the model'));
disp(sprintf('%-58s %s','   md=setflowequation(md,''macayeal'',''all'');','%defines all elements as MacAyeal''s'));
disp(sprintf('%-58s %s','   md=solve(md,DiagnosticSolutionEnum);','%generate the velocity field of the ice shelf'));
disp(sprintf('%-58s %s','   plotmodel(md,''data'',md.results.DiagnosticSolution.Vel);','%displays the velocity (type plotdoc for plotmodel help)'));
