function pargenerate(filename,xm,ym,data,varargin)
%PARGENERATE - generate parameter file for images ala Rignot
%
%   Usage: 
%      pargenerate(filename,data,xm,ym,options);
%
%   Supported options:
%      - title: dataset title
%      - latitude: standard latitude (degree)
%      - meridian: meridian (degree)
%      - format: binary format

%process options
options=pairoptions(varargin{:});
Title=getfieldvalue(options,'title','N/A');
latitude=getfieldvalue(options,'latitude','N/A');
meridian=getfieldvalue(options,'meridian','N/A');
format=getfieldvalue(options,'format','single');

%Get data info
[nlines ncols]=size(data);
xmin=min(xm);
ymax=max(ym);
postx=abs(xm(2)-xm(1));
posty=abs(ym(2)-ym(1));

%Open header file and get machine type
fid=fopen(filename,'wt');
[filename, permission, machineformat, encoding] = fopen(fid);

%write header file
fprintf(fid,'%s\n','ISSM gridded dataset parameter file');
fprintf(fid,'%s%s\n','title: ',Title);
fprintf(fid,'%s  \n','DEM_projection: PS');
fprintf(fid,'%s%s\n','data_format: ',format);
fprintf(fid,'%s%s\n','endian:      ',machineformat);
fprintf(fid,'%s%d\n','width:  ',ncols);
fprintf(fid,'%s%d\n','nlines: ',nlines);
fprintf(fid,'%s%g%s\n','PS_secant_lat:    ',latitude,'   decimal degrees');
fprintf(fid,'%s%g%s\n','PS_meridian_long: ',meridian,'   decimal degrees');
fprintf(fid,'%s%-15.10g\n','PS_corner_north:  ',ymax);
fprintf(fid,'%s%-15.10g\n','PS_corner_east:   ',xmin);
fprintf(fid,'%s%g%s\n','PS_post_north:    ',postx,' m');
fprintf(fid,'%s%g%s\n','PS_post_east:     ',posty,' m');
fclose(fid);
