/*!\file:  exprintf
 * \brief this is a modification of the sprintf function. 
 * Instead of returning an int, it will return the char* itself.
 * The advantage is to be able to do things like: 
 * ErrorException(exprintf("%s%i\n","test failed for id:",id));
 */ 


#include <stdarg.h>
#include <stdio.h>
#include "../Alloc/alloc.h"

char* exprintf(const char* format,...){

	/*returned string: */
	char* string=NULL;

	/*Assum nobody will print more that 1024 characters!*/
	string=(char*)xmalloc(1024*sizeof(char));//assume that nobody will print more than 1024 characters at once.
                                                                                                                                                                                                     
	//variable list of arguments
	va_list ap;

	//First use vsprintf to get the whole input string.
	va_start(ap,format);
	vsprintf(string,format,ap); //printf style coding 
	va_end(ap); 

	return string;
}
