#!/bin/bash

#Some cleanup
rm -rf src
rm -rf install
rm -rf gdal-1.6.0
mkdir src install

#Untar 
tar -zxvf  gdal-1.6.0.tar.gz

#Move gdal into src directory
mv gdal-1.6.0/* src
rm -rf gdal-1.6.0

#Configure gdal
cd src
./configure \
	--prefix="$ISSM_TIER/externalpackages/gdal/install" \
	--without-python \
	--with-netcdf=no \
	--with-jasper=no \
	--without-ld-shared \
	--with-unix-stdio-64=no \
	--with-expat-lib=/usr/lib64/libexpat.so

#Patch GDALmake.opt
patch GDALmake.opt ../GDALmake.opt.patch

#Compile and install gdal
if [ -z $1 ]; then
	make
else
	make -j $1
fi
make install
