#!/bin/sh

./configure \
 --prefix=$ISSM_TIER \
 --with-matlab-dir=$MATLAB_DIR \
 --with-triangle-dir=$ISSM_TIER/externalpackages/triangle/install \
 --with-metis-dir=$ISSM_TIER/externalpackages/metis/install \
 --with-petsc-dir=$ISSM_TIER/externalpackages/petsc/install \
 --with-mpi-include=$ISSM_TIER/externalpackages/mpich2/install/include  \
 --with-mpi-lib="-L$ISSM_TIER/externalpackages/mpich2/install/lib/ -lmpich" \
 --with-petsc-arch=$ISSM_ARCH \
 --with-blas-lapack-dir=$ISSM_TIER/externalpackages/petsc/install \
 --with-plapack-lib="-L$ISSM_TIER/externalpackages/petsc/install/ -lPLAPACK" \
 --with-plapack-include="-I$ISSM_TIER/externalpackages/petsc/install/externalpackages/PLAPACKR32-hg/INCLUDE" \
 --with-blacs-dir=$ISSM_TIER/externalpackages/petsc/install/ \
 --with-scalapack-dir=$ISSM_TIER/externalpackages/petsc/install/ \
 --with-mumps-dir=$ISSM_TIER/externalpackages/petsc/install/ \
 --with-scotch-dir="$ISSM_TIER/externalpackages/scotch/install" \
 --with-chaco-dir="$ISSM_TIER/externalpackages/chaco/install" \
 --with-graphics-lib=/usr/lib64/libX11.so \
 --with-cxxoptflags="-mtune=barcelona -ffast-math -O3 -msse4.2 -Wno-write-strings "\
 --with-numthreads=18 \
 --with-ml-dir=$ISSM_TIER/externalpackages/petsc/install/ \
 --with-hypre-dir=$ISSM_TIER/externalpackages/petsc/install/ \
 --enable-debugging
 
 #--with-dakota-dir=$ISSM_TIER/externalpackages/dakota/install \
 
