%CONSTANTS class definition
%
%   Usage:
%      constants=constants();

classdef constants
	properties (SetAccess=public) 
		g                    = 0;
		yts                  = 0;
		referencetemperature = 0;
	end
	methods
		function obj = constants(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%acceleration due to gravity (m/s^2)
			obj.g=9.81;

			%converstion from year to seconds
			obj.yts=365*24*3600;

			%the reference temperature for enthalpy model (cf Aschwanden)
			obj.referencetemperature=223.15;

		end % }}}
		function flag = checkconsistency(obj,md,solution,analyses) % {{{

			checkfield(md,'constants.g','>',0,'size',[1 1]);
			checkfield(md,'constants.yts','>',0,'size',[1 1]);
			checkfield(md,'constants.referencetemperature','size',[1 1]);

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   constants parameters:'));

			fielddisplay(obj,'g','gravitational acceleration');
			fielddisplay(obj,'yts','number of seconds in a year');
			fielddisplay(obj,'referencetemperature','reference temperature used in the enthalpy model');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','g','format','Double');
			WriteData(fid,'object',obj,'fieldname','yts','format','Double');
			WriteData(fid,'object',obj,'fieldname','referencetemperature','format','Double');
		end % }}}
	end
end
