#!/bin/bash

#Some cleanup
rm -rf install petsc-3.2-p3 src
mkdir install src

#Untar and move petsc to install directory
tar -zxvf  petsc-3.2-p3.tar.gz
mv petsc-3.2-p3/* src/
rm -rf petsc-3.2-p3

#configure
cd src
./config/configure.py \
  --prefix="$ISSM_TIER/externalpackages/petsc/install" \
  --PETSC_DIR="$ISSM_TIER/externalpackages/petsc/src" \
  --PETSC_ARCH=macosx-gnu \
  --with-mpi-dir="$ISSM_TIER/externalpackages/mpich2/install" \
  --with-debugging=0 \
  --with-shared-libraries=0 \
  --download-mumps=yes \
  --download-scalapack=yes \
  --download-blacs=yes \
  --download-blas=yes \
  --download-plapack=yes  \
  --download-parmetis=yes \
  --download-f-blas-lapack=yes 

#Compile petsc and install it
make
make install
