/*! \file DoubleVecExternalResult.h 
 */


#ifndef _DOUBLEVECEXTERNALRESULT_H_
#define _DOUBLEVECEXTERNALRESULT_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./ExternalResult.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class DoubleVecExternalResult: public ExternalResult{

	private: 
		int id;
		int enum_type;
		double* values;
		int M;
		int step;
		double time;

	public:
		/*DoubleVecExternalResult constructors, destructors: {{{1*/
		DoubleVecExternalResult();
		DoubleVecExternalResult(int id,int enum_type,double* values,int M,int step, double time);
		~DoubleVecExternalResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ExternalResult management: {{{1*/
		int   InstanceEnum(){return enum_type;}
		void  WriteData(FILE* fid,bool io_gather);
		void  GetResultName(char**);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif
		int   GetStep(void);
		/*}}}*/
};
#endif  /* _DOUBLEVECEXTERNALRESULT_H */
