#!/bin/bash

#Get number of cpus
NUMCPUS=$1;

#functions
function todaydate() #{{{1
{
	suffix=`date | awk '{printf("%s-%s-%s-%s",$2,$3,$6,$4);}'`			 
	echo $suffix;			 
} #}}}


#get today's date.
today=`todaydate`

#Run scanning tools on code.
step=3;

#dyson:  step 1{{{1
if [[ $step == "1" ]];
then
	cd $ISSM_TIER/externalpackages/dyson
	./source_seek.sh $ISSM_TIER/src/m/  > $ISSM_DIR_UCI/itsecurity/reports/dyson-$today  2>&1
fi
#}}}
#rats:  step 2{{{1
if [[ $step == "2" ]];
then
	cd $ISSM_TIER/src/c
	rats  `find ./ -name "*.cpp"`  > $ISSM_DIR_UCI/itsecurity/reports/rats-$today
fi
#}}}
#cppcheck:  step 3{{{1
if [[ $step == "3" ]];
then
	cd $ISSM_TIER/src/c

	INCLUDEDIRS="-I $ISSM_TIER/src/c -I $ISSM_TIER -I $ISSM_TIER/externalpackages/petsc/install/include -I $ISSM_TIER/externalpackages/mpich2/install/include -I $ISSM_TIER/externalpackages/matlab/install/extern/include -I $ISSM_TIER/externalpackages/triangle/install -I $ISSM_TIER/externalpackages/dakota/install/include -I $ISSM_TIER/externalpackages/chaco/install/include -I $ISSM_TIER/externalpackages/scotch/install/include -I $ISSM_TIER/externalpackages/dakota/src/methods/OPTPP/include/  -I $ISSM_TIER/src/c/toolkits/petsc"
	if [ -z $NUMCPUS ];
	then
		cppcheck  --force $INCLUDEDIRS --enable=all ./ 2>$ISSM_DIR_UCI/itsecurity/reports/cppcheck-error-$today
	else
		cppcheck  --force $INCLUDEDIRS -j 24 --enable=all ./ 2>$ISSM_DIR_UCI/itsecurity/reports/cppcheck-error-$today
	fi
fi
#}}}
