function ismodelselfconsistent(md),
%ISMODELSELFCONSISTENT - check that model forms a closed form solvable problem.
%
%   Usage:
%      ismodelselfconsistent(md),

%initialize consistency as true
modelconsistency(true);

%Get solution and associated analyses
solution=md.private.solution;
[analyses,numanalyses]=AnalysisConfiguration(solution);

%Go through al model field check that it is a class and call checkconsistency
fields=properties('model');
for i=1:length(fields),
	field=fields{i};

	%Some properties do not need to be checked
	if ismember(field,{'results' 'debug' 'radaroverlay'}),
		continue;
	end

	%Check that current field is an object
	if ~isobject(md.(field))
		checkmessage(['field ''' char(field) ''' is not an object']);
	end

	%Check consistency of the object
	md.(field).checkconsistency(md,solution,analyses);
end

%error message if mode is not consistent
if modelconsistency==false,
	error(' ');
end
