%RADAROVERLAY class definition
%
%   Usage:
%      radaroverlay=radaroverlay();

classdef radaroverlay
	properties (SetAccess=public) 
		pwr = NaN;
		x   = NaN;
		y   = NaN;
	end
	methods
		function obj = radaroverlay(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   radaroverlay parameters:'));

			fielddisplay(obj,'pwr','radar power image (matrix)');
			fielddisplay(obj,'x','corresponding x coordinates');
			fielddisplay(obj,'y','corresponding y coordinates');

		end % }}}
	end
end
