/*!\file KML_ColorStyle.cpp
 * \brief: implementation of the kml_colorstyle abstract object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_ColorStyle::KML_ColorStyle(){{{1*/
KML_ColorStyle::KML_ColorStyle(){

	strcpy(color     ,"ffffffff");
	strcpy(colormode ,"normal");

}
/*}}}*/
/*FUNCTION KML_ColorStyle::~KML_ColorStyle(){{{1*/
KML_ColorStyle::~KML_ColorStyle(){

	;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_ColorStyle::Echo {{{1*/
void  KML_ColorStyle::Echo(){

	bool  flag=true;

	KML_SubStyle::Echo();

	_printf_(flag,"         color: %s\n"          ,color);
	_printf_(flag,"     colormode: %s\n"          ,colormode);

	return;
}
/*}}}*/
/*FUNCTION KML_ColorStyle::DeepEcho {{{1*/
void  KML_ColorStyle::DeepEcho(){

	char  indent[81]="";

	KML_ColorStyle::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION KML_ColorStyle::DeepEcho {{{1*/
void  KML_ColorStyle::DeepEcho(const char* indent){

	bool  flag=true;

	KML_SubStyle::DeepEcho(indent);

	_printf_(flag,"%s         color: %s\n"          ,indent,color);
	_printf_(flag,"%s     colormode: %s\n"          ,indent,colormode);

	return;
}
/*}}}*/
/*FUNCTION KML_ColorStyle::Write {{{1*/
void  KML_ColorStyle::Write(FILE* filout,const char* indent){

	KML_SubStyle::Write(filout,indent);

	if (color     && strlen(color))
		fprintf(filout,"%s  <color>%s</color>\n",indent,color);
	if (colormode && strlen(colormode))
		fprintf(filout,"%s  <colorMode>%s</colorMode>\n",indent,colormode);

	return;
}
/*}}}*/
/*FUNCTION KML_ColorStyle::Read {{{1*/
void  KML_ColorStyle::Read(FILE* fid,char* kstr){

/*  process field within opening and closing tags  */

	if      (!strncmp(kstr,"</ColorStyle",12))
		return;
	else if (!strncmp(kstr,"</",2))
		_error_("KML_ColorStyle::Read -- Unexpected closing tag %s.\n",kstr);
	else if (strncmp(kstr,"<",1))
		_error_("KML_ColorStyle::Read -- Unexpected field \"%s\".\n",kstr);

	else if (!strcmp(kstr,"<color>"))
		KMLFileTokenParse( color     ,NULL,KML_COLORSTYLE_COLOR_LENGTH,
						  kstr,
						  fid);
	else if (!strcmp(kstr,"<colorMode>"))
		KMLFileTokenParse( colormode ,NULL,KML_COLORSTYLE_COLORMODE_LENGTH,
						  kstr,
						  fid);

	else if (!strncmp(kstr,"<",1))
		KML_SubStyle::Read(fid,kstr);

	return;
}
/*}}}*/
