/*!\file KML_Style.cpp
 * \brief: implementation of the kml_style object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Style::KML_Style(){{{1*/
KML_Style::KML_Style(){

	icon      =NULL;
	label     =NULL;
	line      =NULL;
	poly      =NULL;
	balloon   =NULL;
	list      =NULL;

}
/*}}}*/
/*FUNCTION KML_Style::~KML_Style(){{{1*/
KML_Style::~KML_Style(){

	if (list) {
//		delete list;
		if (list      ) xfree((void**)&list);
		list      =NULL;
	}
	if (balloon) {
//		delete balloon;
		if (balloon   ) xfree((void**)&balloon);
		balloon   =NULL;
	}
	if (poly) {
		delete poly;
		poly      =NULL;
	}
	if (line) {
		delete line;
		line      =NULL;
	}
	if (label) {
//		delete label;
		if (label     ) xfree((void**)&label);
		label     =NULL;
	}
	if (icon) {
//		delete icon;
		if (icon      ) xfree((void**)&icon);
		icon      =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Style::Echo {{{1*/
void  KML_Style::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Style:\n");
	KML_StyleSelector::Echo();

	_printf_(flag,"          icon: %p\n"          ,icon);
	_printf_(flag,"         label: %p\n"          ,label);
	_printf_(flag,"          line: %p\n"          ,line);
	_printf_(flag,"          poly: %p\n"          ,poly);
	_printf_(flag,"       balloon: %p\n"          ,balloon);
	_printf_(flag,"          list: %p\n"          ,list);

	return;
}
/*}}}*/

/*FUNCTION KML_Style::DeepEcho {{{1*/
void  KML_Style::DeepEcho(){

	char  indent[81]="";

	KML_Style::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Style::DeepEcho {{{1*/
void  KML_Style::DeepEcho(const char* indent){

	char  indent2[81];
	bool  flag=true;

	_printf_(flag,"%sKML_Style:\n",indent);
	KML_StyleSelector::DeepEcho(indent);

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

//	if (icon)
//		icon->DeepEcho(indent2);
//	else
		_printf_(flag,"%s          icon: %p\n"          ,indent,icon);
//	if (label)
//		label->DeepEcho(indent2);
//	else
		_printf_(flag,"%s         label: %p\n"          ,indent,label);
	if (line)
		line->DeepEcho(indent2);
	else
		_printf_(flag,"%s          line: %p\n"          ,indent,line);
	if (poly)
		poly->DeepEcho(indent2);
	else
		_printf_(flag,"%s          poly: %p\n"          ,indent,poly);
//	if (balloon)
//		balloon->DeepEcho(indent2);
//	else
		_printf_(flag,"%s       balloon: %p\n"          ,indent,balloon);
//	if (list)
//		list->DeepEcho(indent2);
//	else
		_printf_(flag,"%s          list: %p\n"          ,indent,list);

	return;
}
/*}}}*/

/*FUNCTION KML_Style::Write {{{1*/
void  KML_Style::Write(FILE* filout,char* indent){

	char  indent2[81];

	fprintf(filout,"%s<Style",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");
	WriteCommnt(filout,indent);

	KML_StyleSelector::Write(filout,indent);

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

//	if (icon)
//		icon->Write(filout,indent2);
//	if (label)
//		label->Write(filout,indent2);
	if (line)
		line->Write(filout,indent2);
	if (poly)
		poly->Write(filout,indent2);
//	if (balloon)
//		balloon->Write(filout,indent2);
//	if (list)
//		list->Write(filout,indent2);

	fprintf(filout,"%s</Style>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Style::Read {{{1*/
void  KML_Style::Read(FILE* fid,char* kstr){

	char*        kstri;
	int          ncom=0;
	char**       pcom=NULL;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid,
							  &ncom,&pcom)) {
		if      (!strncmp(kstri,"</Style", 7)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_Style::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_Style::Read -- Unexpected field \"%s\".\n",kstri);

//		else if (!strncmp(kstri,"<IconStyle",10)) {
//			icon      =new KML_IconStyle();
//			icon      ->Read(fid,kstri);
//		}

//		else if (!strncmp(kstri,"<LabelStyle",11)) {
//			label     =new KML_LabelStyle();
//			label     ->Read(fid,kstri);
//		}

		else if (!strncmp(kstri,"<LineStyle",10)) {
			line      =new KML_LineStyle();
			line      ->Read(fid,kstri);
		}

		else if (!strncmp(kstri,"<PolyStyle",10)) {
			poly      =new KML_PolyStyle();
			poly      ->Read(fid,kstri);
		}

//		else if (!strncmp(kstri,"<BalloonStyle",13)) {
//			balloon   =new KML_BalloonStyle();
//			balloon   ->Read(fid,kstri);
//		}

//		else if (!strncmp(kstri,"<ListStyle",10)) {
//			list      =new KML_ListStyle();
//			list      ->Read(fid,kstri);
//		}

		else if (!strncmp(kstri,"<",1))
			KML_StyleSelector::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	this->AddCommnt(ncom,pcom);

	for (ncom; ncom>0; ncom--)
		xfree((void**)&(pcom[ncom-1]));
	xfree((void**)&pcom);

	return;
}
/*}}}*/

