/*!\file KML_PolyStyle.cpp
 * \brief: implementation of the kml_polystyle object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_PolyStyle::KML_PolyStyle(){{{1*/
KML_PolyStyle::KML_PolyStyle(){

	fill      =true;
	outline   =true;

}
/*}}}*/
/*FUNCTION KML_PolyStyle::~KML_PolyStyle(){{{1*/
KML_PolyStyle::~KML_PolyStyle(){

	;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_PolyStyle::Echo {{{1*/
void  KML_PolyStyle::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_PolyStyle:\n");
	KML_ColorStyle::Echo();

	_printf_(flag,"          fill: %d\n"          ,fill);
	_printf_(flag,"       outline: %d\n"          ,outline);

	return;
}
/*}}}*/

/*FUNCTION KML_PolyStyle::DeepEcho {{{1*/
void  KML_PolyStyle::DeepEcho(){

	char  indent[81]="";

	KML_PolyStyle::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_PolyStyle::DeepEcho {{{1*/
void  KML_PolyStyle::DeepEcho(const char* indent){

	int   i;
	bool  flag=true;

	_printf_(flag,"%sKML_PolyStyle:\n",indent);
	KML_ColorStyle::DeepEcho(indent);

	_printf_(flag,"%s          fill: %d\n"          ,indent,fill);
	_printf_(flag,"%s       outline: %d\n"          ,indent,outline);

	return;
}
/*}}}*/

/*FUNCTION KML_PolyStyle::Write {{{1*/
void  KML_PolyStyle::Write(FILE* filout,char* indent){

	fprintf(filout,"%s<PolyStyle",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");
	WriteCommnt(filout,indent);

	KML_ColorStyle::Write(filout,indent);

	fprintf(filout,"%s  <fill>%d</fill>\n",indent,fill);
	fprintf(filout,"%s  <outline>%d</outline>\n",indent,outline);

	fprintf(filout,"%s</PolyStyle>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_PolyStyle::Read {{{1*/
void  KML_PolyStyle::Read(FILE* fid,char* kstr){

	char*        kstri;
	int          ncom=0;
	char**       pcom=NULL;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid,
							  &ncom,&pcom)) {
		if      (!strncmp(kstri,"</PolyStyle",11)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_PolyStyle::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_PolyStyle::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strcmp(kstri,"<fill>"))
			KMLFileTokenParse(&fill      ,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<outline>"))
			KMLFileTokenParse(&outline   ,
							  kstri,
							  fid);

		else if (!strncmp(kstri,"<",1))
			KML_ColorStyle::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	this->AddCommnt(ncom,pcom);

	for (ncom; ncom>0; ncom--)
		xfree((void**)&(pcom[ncom-1]));
	xfree((void**)&pcom);

	return;
}
/*}}}*/

