/*!\file KML_GroundOverlay.cpp
 * \brief: implementation of the kml_groundoverlay object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_GroundOverlay::KML_GroundOverlay(){{{1*/
KML_GroundOverlay::KML_GroundOverlay(){

	altitude  = 0.;
	memcpy(altmode,"clampToGround",(strlen("clampToGround")+1)*sizeof(char));

	llbox     =NULL;

}
/*}}}*/
/*FUNCTION KML_GroundOverlay::~KML_GroundOverlay(){{{1*/
KML_GroundOverlay::~KML_GroundOverlay(){

	if (llbox) {
		delete llbox;
		llbox     =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_GroundOverlay::Echo {{{1*/
void  KML_GroundOverlay::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_GroundOverlay:\n");
	KML_Overlay::Echo();

	_printf_(flag,"      altitude: %0.16g\n"      ,altitude);
	_printf_(flag,"       altmode: \"%s\"\n"      ,altmode);
	_printf_(flag,"         llbox: %p\n"          ,llbox);

	return;
}
/*}}}*/

/*FUNCTION KML_GroundOverlay::DeepEcho {{{1*/
void  KML_GroundOverlay::DeepEcho(){

	char  indent[81]="";

	KML_GroundOverlay::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_GroundOverlay::DeepEcho {{{1*/
void  KML_GroundOverlay::DeepEcho(const char* indent){

	char  indent2[81];
	bool  flag=true;

	_printf_(flag,"%sKML_GroundOverlay:\n",indent);
	KML_Overlay::DeepEcho(indent);

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

	_printf_(flag,"%s      altitude: %0.16g\n"      ,indent,altitude);
	_printf_(flag,"%s       altmode: \"%s\"\n"      ,indent,altmode);
	if (llbox)
		llbox->DeepEcho(indent2);
	else
		_printf_(flag,"%s         llbox: %p\n"          ,indent,llbox);

	return;
}
/*}}}*/

/*FUNCTION KML_GroundOverlay::Write {{{1*/
void  KML_GroundOverlay::Write(FILE* filout,char* indent){

	char  indent2[81];

	fprintf(filout,"%s<GroundOverlay",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");
	WriteCommnt(filout,indent);

	KML_Overlay::Write(filout,indent);

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

	fprintf(filout,"%s  <altitude>%0.16g</altitude>\n",indent,altitude);
	fprintf(filout,"%s  <altitudeMode>%s</altitudeMode>\n",indent,altmode);
	if (llbox)
		llbox->Write(filout,indent2);

	fprintf(filout,"%s</GroundOverlay>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_GroundOverlay::Read {{{1*/
void  KML_GroundOverlay::Read(FILE* fid,char* kstr){

	char*        kstri;
	int          ncom=0;
	char**       pcom=NULL;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid,
							  &ncom,&pcom)) {
		if      (!strncmp(kstri,"</GroundOverlay",15)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_GroundOverlay::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_GroundOverlay::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strcmp(kstri,"<altitude>"))
			KMLFileTokenParse(&altitude  ,
							  kstri,
							  fid);
		else if (!strcmp(kstri,"<altitudeMode>"))
			KMLFileTokenParse( altmode   ,NULL,KML_GROUNDOVERLAY_ALTMODE_LENGTH,
							  kstri,
							  fid);
		else if (!strncmp(kstri,"<LatLonBox",10)) {
			llbox     =new KML_LatLonBox();
			llbox     ->Read(fid,kstri);
		}

		else if (!strncmp(kstri,"<",1))
			KML_Overlay::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	this->AddCommnt(ncom,pcom);

	for (ncom; ncom>0; ncom--)
		xfree((void**)&(pcom[ncom-1]));
	xfree((void**)&pcom);

	return;
}
/*}}}*/

