/*!\file KML_Folder.cpp
 * \brief: implementation of the kml_folder object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Folder::KML_Folder(){{{1*/
KML_Folder::KML_Folder(){

	;

}
/*}}}*/
/*FUNCTION KML_Folder::~KML_Folder(){{{1*/
KML_Folder::~KML_Folder(){

	;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Folder::Echo {{{1*/
void  KML_Folder::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Folder:\n");
	KML_Container::Echo();

	return;
}
/*}}}*/

/*FUNCTION KML_Folder::DeepEcho {{{1*/
void  KML_Folder::DeepEcho(){

	char  indent[81]="";

	KML_Folder::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Folder::DeepEcho {{{1*/
void  KML_Folder::DeepEcho(const char* indent){

	bool  flag=true;

	_printf_(flag,"%sKML_Folder:\n",indent);
	KML_Container::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Folder::Write {{{1*/
void  KML_Folder::Write(FILE* filout,char* indent){

	fprintf(filout,"%s<Folder",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");
	WriteCommnt(filout,indent);

	KML_Container::Write(filout,indent);

	fprintf(filout,"%s</Folder>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Folder::Read {{{1*/
void  KML_Folder::Read(FILE* fid,char* kstr){

	char*        kstri;
	int          ncom=0;
	char**       pcom=NULL;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid,
							  &ncom,&pcom)) {
		if      (!strncmp(kstri,"</Folder", 8)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_Folder::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_Folder::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strncmp(kstri,"<",1))
			KML_Container::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	this->AddCommnt(ncom,pcom);

	for (ncom; ncom>0; ncom--)
		xfree((void**)&(pcom[ncom-1]));
	xfree((void**)&pcom);

	return;
}
/*}}}*/

