/*!\file KML_MultiGeometry.cpp
 * \brief: implementation of the kml_multigeometry object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_MultiGeometry::KML_MultiGeometry(){{{1*/
KML_MultiGeometry::KML_MultiGeometry(){

	geometry  =new DataSet;

}
/*}}}*/
/*FUNCTION KML_MultiGeometry::~KML_MultiGeometry(){{{1*/
KML_MultiGeometry::~KML_MultiGeometry(){

	if (geometry) {
		delete geometry;
		geometry  =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_MultiGeometry::Echo {{{1*/
void  KML_MultiGeometry::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Multigeometry:\n");
	KML_Geometry::Echo();

	_printf_(flag,"      geometry: (size=%d)\n" ,geometry->Size());

	return;
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::DeepEcho {{{1*/
void  KML_MultiGeometry::DeepEcho(){

	char  indent[81]="";

	KML_MultiGeometry::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::DeepEcho {{{1*/
void  KML_MultiGeometry::DeepEcho(char* indent){

	int   i;
	char  indent2[81];
	bool  flag=true;

	_printf_(flag,"%sKML_Multigeometry:\n",indent);
	KML_Geometry::DeepEcho(indent);

/*  loop over the geometry elements for the multigeometry  */

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

	if (geometry->Size())
		for (i=0; i<geometry->Size(); i++) {
			_printf_(flag,"%s      geometry: -------- begin [%d] --------\n" ,indent,i);
			((KML_Geometry *)geometry->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s      geometry: --------  end  [%d] --------\n" ,indent,i);
		}
	else
		_printf_(flag,"%s      geometry: [empty]\n"    ,indent);

	return;
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::Write {{{1*/
void  KML_MultiGeometry::Write(FILE* filout,char* indent){

	int   i;
	char  indent2[81];

	fprintf(filout,"%s<MultiGeometry",indent);
	WriteAttrib(filout," ");
	fprintf(filout,">\n");
	WriteCommnt(filout,indent);

	KML_Geometry::Write(filout,indent);

/*  loop over the geometry elements for the multigeometry  */

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

	for (i=0; i<geometry->Size(); i++)
		((KML_Geometry *)geometry->GetObjectByOffset(i))->Write(filout,indent2);

	fprintf(filout,"%s</MultiGeometry>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::Read {{{1*/
void  KML_MultiGeometry::Read(FILE* fid,char* kstr){

	char*        kstri;
	int          ncom=0;
	char**       pcom=NULL;
	KML_Object*  kobj;

/*  get object attributes and check for solo tag  */

	if (KMLFileTagAttrib(this,
						 kstr))
		return;

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid,
							  &ncom,&pcom)) {
		if      (!strncmp(kstri,"</MultiGeometry",15)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_MultiGeometry::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_MultiGeometry::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strncmp(kstri,"<Point", 6)) {
			kobj=(KML_Object*)new KML_Point();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<LineString",11)) {
			kobj=(KML_Object*)new KML_LineString();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<LinearRing",11)) {
			kobj=(KML_Object*)new KML_LinearRing();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<Polygon", 8)) {
			kobj=(KML_Object*)new KML_Polygon();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<MultiGeometry",14)) {
			kobj=(KML_Object*)new KML_MultiGeometry();
			kobj->Read(fid,kstri);
			geometry  ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<",1))
			KML_Geometry::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	this->AddCommnt(ncom,pcom);

	for (ncom; ncom>0; ncom--)
		xfree((void**)&(pcom[ncom-1]));
	xfree((void**)&pcom);

	return;
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::WriteExp {{{1*/
void  KML_MultiGeometry::WriteExp(FILE* fid,const char* nstr,int sgn,double cm,double sp){

	int   i;

/*  loop over the geometry elements for the multigeometry  */

	for (i=0; i<geometry->Size(); i++)
		((KML_Object *)geometry->GetObjectByOffset(i))->WriteExp(fid,nstr,sgn,cm,sp);

	return;
}
/*}}}*/

