/*!\file KML_Attribute.cpp
 * \brief: implementation of the kml_attribute object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Attribute::KML_Attribute(){{{1*/
KML_Attribute::KML_Attribute(){

	name      =NULL;
	value     =NULL;

}
/*}}}*/
/*FUNCTION KML_Attribute::~KML_Attribute(){{{1*/
KML_Attribute::~KML_Attribute(){

	if (name      ) xfree((void**)&name);
	if (value     ) xfree((void**)&value);

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Attribute::Echo {{{1*/
void  KML_Attribute::Echo(){

	int   i;
	bool  flag=true;

	_printf_(flag,"    ");
	for (i=0;i<10-strlen(name);i++)
		_printf_(flag," ");
	_printf_(flag,"%s: \"%s\"\n",name,value);

	return;
}
/*}}}*/
/*FUNCTION KML_Attribute::DeepEcho {{{1*/
void  KML_Attribute::DeepEcho(){

	char  indent[81]="";

	KML_Attribute::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION KML_Attribute::DeepEcho {{{1*/
void  KML_Attribute::DeepEcho(const char* indent){

	int   i;
	bool  flag=true;

	_printf_(flag,"%s    ",indent);
	for (i=0;i<10-strlen(name);i++)
		_printf_(flag," ");
	_printf_(flag,"%s: \"%s\"\n",name,value);

	return;
}
/*}}}*/
/*FUNCTION KML_Attribute::Write {{{1*/
void  KML_Attribute::Write(FILE* filout,char* indent){

//  attributes always written in keyword line of kml_object

	fprintf(filout,"%s%s=\"%s\"",indent,name,value);

	return;
}
/*}}}*/
/*FUNCTION KML_Attribute::Read {{{1*/
void  KML_Attribute::Read(FILE* fid,char* kstr){

//  attributes always read in keyword line of kml_object

	;

	return;
}
/*}}}*/
/*FUNCTION KML_Attribute::Alloc {{{1*/
void  KML_Attribute::Alloc(char* namei,char* valuei){

	name =(char *) xmalloc((strlen(namei )+1)*sizeof(char));
	memcpy(name,namei,(strlen(namei)+1)*sizeof(char));

	value=(char *) xmalloc((strlen(valuei)+1)*sizeof(char));
	memcpy(value,valuei,(strlen(valuei)+1)*sizeof(char));

	return;
}
/*}}}*/
/*FUNCTION KML_Attribute::Add {{{1*/
void  KML_Attribute::Add(DataSet* attrib){

	attrib->AddObject((Object*)this);

	return;
}
/*}}}*/
/*FUNCTION KML_Attribute::Get {{{1*/
void  KML_Attribute::Get(char** pvalueo,char* deflt){

	if (!value || !strlen(value)) {
		*pvalueo=(char *) xmalloc((strlen(deflt)+1)*sizeof(char));
		memcpy(*pvalueo,deflt,(strlen(deflt)+1)*sizeof(char));
	}
	else {
		*pvalueo=(char *) xmalloc((strlen(value)+1)*sizeof(char));
		memcpy(*pvalueo,value,(strlen(value)+1)*sizeof(char));
	}

	return;
}
/*}}}*/
