function plot_scatter(x,y,mksize,level),

%check input
if numel(x)~=numel(y) | numel(x)~=numel(level),
	error('x, y and data should have the same size');
end

%Some processing
Min=min(level);
Max=max(level);
Siz=length(level);
nlab=10;

%OK, should we create a new colorbar for the occasion?
if isempty(findobj(gcf,'tag','TMW_COLORBAR')),
	alreadyplot=false;
else
	alreadyplot=true;
end

%generate levels
if (alreadyplot),
	phch = get(findall(gcf,'type','image','tag','TMW_COLORBAR'),{'parent'});
	h    = phch{1};
	ylim=get(h,'YLim');
	palette=colormap;
	numcolors=size(palette,1);
	levels=round_ice(linspace(ylim(1),ylim(2),numcolors+1),2);
else
	numcolors=30;
	levels=round_ice(linspace(Min,Max,numcolors+1),2);
	palette=colormap(jet(numcolors));
end

colorind=ones(Siz,1);
for i=1:numcolors
	pos=find((level>=levels(i)) & (level<=levels(i+1)) );
	colorind(pos)=i;
end
colorind(find(level>levels(end)))=numcolors;

%loop over the number of colors
hold on
hp=[];
for i=1:numcolors
	pos=find(colorind==i);
	hprime=plot(x(pos),y(pos),...
		'o','MarkerSize',mksize,'MarkerEdgeColor',palette(i,:),...
		'MarkerFaceColor',palette(i,:));
	hp=[hp;hprime];
end

alreadyplot
if ~alreadyplot,
	% format the colorbar
	h    = colorbar;
	nlab = abs(nlab);                       % number of labels must be positive
	set(h,'YLim',[1 numcolors]);                  % set colorbar limits
	set(h,'YTick',linspace(1,numcolors,nlab));    % set tick mark locations

	labels = cell(1,nlab);
	tick_vals = linspace(Min,Max,nlab);
	warning off MATLAB:log:logOfZero;
	for i = 1:nlab
		if min(log10(abs(tick_vals))) <= 3, fm = '%-4.0f';   % fixed
		else                                fm = '%-4.0E';   % floating
		end
		labels{i} = sprintf(fm,tick_vals(i));
	end
	warning on MATLAB:log:logOfZero;

	% set tick label strings
	set(h,'YTickLabel',labels);
	%colorbar %one last time required sometimes
end
