function femmodel=NewFemModel(md,solution_type,analysis_types,nummodels);
%NEWFEMMODEL - create a finite element model out of the matlab base \@model md. 
%   For each analysis_type contained in analysis_types, create a set of nodes, constraints 
%   and loads. All analyses rely on the same elements, vertices and parameters. See 
%   FemModel.cpp in src/c/objects for more information on the FemModel implementation in c++
%
%   Usage:
%      femmodel=NewFemModel(md,solution_type,analysis_types,nummodels)
%

	%Set verbosity
	SetVerbosityLevel(VerboseToBinary(md.verbose));

   %Dynamically allocate whatever is a list of length nummodels: */
   femmodel.solution_type=solution_type;
   femmodel.analysis_counter=nummodels; %point to last analysis_type carried out
   femmodel.analysis_type_list=analysis_types;

	issmprintf(VerboseMProcessor(),'\n   reading data from input file %s.bin...',md.miscellaneous.name);
   [femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.constraints,femmodel.loads,femmodel.materials,femmodel.parameters]=ModelProcessor([md.miscellaneous.name '.bin'],solution_type,femmodel.analysis_type_list);
   
	%Initialize some fiels with empty celils
	femmodel.results=struct([]);

	%now, go through all analyses types and post-process datasets
	for i=1:nummodels,

		analysis_type=femmodel.analysis_type_list(i);
		issmprintf(VerboseMProcessor(),'%s%s','   dealing with analysis type: ',EnumToString(analysis_type));

		femmodel=SetCurrentConfiguration(femmodel,analysis_type);

		if i==1, %only  create vertices dofs once!
			issmprintf(VerboseMProcessor(),'%s','      generating vertices degrees of freedom');
			femmodel.vertices=VerticesDof(femmodel.vertices, femmodel.parameters); 
		end

		issmprintf(VerboseMProcessor(),'%s','      resolving node constraints');
		[femmodel.nodes]=SpcNodes(femmodel.nodes,femmodel.constraints,femmodel.parameters,analysis_type);

		issmprintf(VerboseMProcessor(),'%s','      creating nodal degrees of freedom');
		[femmodel.nodes]=NodesDof(femmodel.nodes,femmodel.parameters);

		issmprintf(VerboseMProcessor(),'%s','      configuring elements and loads');
		[femmodel.elements,femmodel.loads,femmodel.nodes,femmodel.parameters] = ConfigureObjects( femmodel.elements, femmodel.loads, femmodel.nodes, femmodel.vertices,femmodel.materials,femmodel.parameters);
	end
