function md=geography2(md,landname,iceshelfname,icesheetname)

%Get assigned fields
x=md.x;
y=md.y;
elements=md.elements;

%recover elements and grids on land.
[gridonland,elementonland]=ContourToMesh(elements,x,y,expread(landname,1),'element and node',1);

%use segments to make sure gridonland is correct at the boundary:
gridonland(md.segments(:,1))=1;
gridonland(md.segments(:,2))=1;

%now, any elements with 3 grids on land should be on land:
elementsonwater=find(~elementonland);
wrongelements=elementsonwater(find(( gridonland(md.elements(elementsonwater,1)) + gridonland(md.elements(elementsonwater,2)) + gridonland(md.elements(elementsonwater,3)) ...
                  )==3));
elementonland(wrongelements)=1;

%finally, any element with its barycentre in the water should be in the water!
xelem=x(md.elements)*[1;1;1]/3; yelem=y(md.elements)*[1;1;1]/3;
baryonland=ContourToNodes(xelem,yelem,expread(landname,1),1);
pos=find(~baryonland); elementonland(pos)=0;

%figure out which elements on land are actually in the middle of the ocean!
pos1=find(elementonland); 
connectedtoland=md.elementconnectivity(pos1,:);
pos=find(connectedtoland); connectedtoland(pos)=1-elementonland(connectedtoland(pos));
connectedtolandsum=sum(connectedtoland,2);
waterelements=pos1(find(connectedtolandsum==3));

%now use waterelements to correct elementonland: 
elementonland(waterelements)=0;

%recover arrays of ice shelf grids and elements, and ice sheet grids and elements.
if strcmp(iceshelfname,''), %no iceshelf contour file, we are dealing with a pure ice sheet.
	gridoniceshelf=zeros(md.numberofgrids,1);
	elementoniceshelf=zeros(md.numberofelements,1);
elseif strcmp(iceshelfname,'all'), %we are dealing with a pure ice shelf.
	gridoniceshelf=ones(md.numberofgrids,1);
	elementoniceshelf=ones(md.numberofelements,1);
else
	[gridoniceshelf,elementoniceshelf]=ContourToMesh(elements,x,y,expread(iceshelfname,1),'element and node',1);
end

if strcmp(icesheetname,''), %no icesheet contour file, we are dealing with a pure ice shelf.
	gridonicesheet=zeros(md.numberofgrids,1);
	elementonicesheet=zeros(md.numberofelements,1);
else
	[gridonicesheet,elementonicesheet]=ContourToMesh(elements,x,y,expread(icesheetname,1),'element and node',1);
end


%now correct, so that none of the iceshelf and icesheet elements and nodes are in the water.
pos=find(~elementonland);
elementoniceshelf(pos)=0; 
elementonicesheet(pos)=0;

pos=find(~gridonland);
gridoniceshelf(pos)=0; 
gridonicesheet(pos)=0;

%create gridonwater and elementonwater: 
gridonwater=double(~gridonland);
elementonwater=double(~elementonland);

%correct for islands:
gridoniceshelf=double(gridoniceshelf & ~gridonicesheet);
elementoniceshelf=double(elementoniceshelf & ~elementonicesheet);

%now, icesheets are everything except iceshelves and water
gridonicesheet=double(~gridoniceshelf & ~gridonwater);
elementonicesheet=double(~elementoniceshelf & ~elementonwater);

%Return: 
md.gridoniceshelf=gridoniceshelf;
md.elementoniceshelf=elementoniceshelf;

md.gridonwater=gridonwater;
md.elementonwater=elementonwater;

md.gridonicesheet=gridonicesheet;
md.elementonicesheet=elementonicesheet;

%Deal with segments on neumann: 
pos=find(md.segmentmarkers==2); %internal segments.
segments=md.segments(pos,:);

%swap segments so they are all oriented the same way
for i=1:length(segments),
	pair=find(  (md.elements(:,1)==segments(i,1)  | md.elements(:,2)==segments(i,1)  | md.elements(:,3)==segments(i,1) ) & ...
	            (md.elements(:,1)==segments(i,2)  | md.elements(:,2)==segments(i,2)  | md.elements(:,3)==segments(i,2) )   ...
			 );
    if md.elementonwater(pair(1)),
		segments(i,3)=pair(2);
	else
		segments(i,3)=pair(1);
	end
	ord1=find(segments(i,1)==md.elements(segments(i,3),:));
	ord2=find(segments(i,2)==md.elements(segments(i,3),:));
	
	%swap segment grids if necessary
	if ( (ord1==1 & ord2==2) | (ord1==2 & ord2==3) | (ord1==3 & ord2==1) ),
		temp=segments(i,1);
		segments(i,1)=segments(i,2);
		segments(i,2)=temp;
	end
	segments(i,1:2)=fliplr(segments(i,1:2));
end
md.segmentonneumann_diag=segments;
md.counter=2;
md.segmentmarkers(:)=1;


