function BuildQueueingScriptgemini(md,executionpath,codepath)
%BUILDQUEUEINGSCRIPTGEMINI - ...
%
%   Usage:
%      BuildQueueingScriptgemini(md,executionpath,codepath)

scriptname=[md.name '.queue'];

fid=fopen(scriptname,'w');
if fid==-1,
	error(['BuildQueueingScriptgeminierror message: could not open ' scriptname ' file for ascii writing']);
end

fprintf(fid,'#!/bin/csh\n');
fprintf(fid,'#PBS -l walltime=%i\n',md.time);
fprintf(fid,'#PBS -l ncpus=%i\n',md.np);
if ~isempty(md.queue),
	fprintf(fid,'#PBS -q %s\n',md.queue);
end
fprintf(fid,'#PBS -o %s.outlog \n',md.name);
fprintf(fid,'#PBS -e %s.errlog \n',md.name);

fprintf(fid,'setenv PBS_O_WORKDIR %s\n',executionpath);
fprintf(fid,'cd $PBS_O_WORKDIR\n');
fprintf(fid,'setenv OMP_NUM_THREADS 1\n');
fprintf(fid,'mpirun -np %i %s/%s.exe %s %s.bin %s.outbin %s.lock',md.np,codepath,md.analysis_type,executionpath,md.name,md.name,md.name);

fclose(fid);
