function plot_segments(md,options_structure,width,i,datai);
%PLOT_SEGMENTS - plot segments, with different colors according to segment markers.
%
%   Usage:
%      plot_segments(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%plot mesh boundaries
subplot(width,width,i); 

%units
if ~isnan(options_structure.unitmultiplier),
	md.x=md.x*options_structure.unitmultiplier;
	md.y=md.y*options_structure.unitmultiplier;
	md.z=md.z*options_structure.unitmultiplier;
end

segments=md.segments;

length=sqrt( (md.x(segments(:,1))-md.x(segments(:,2))).^2 + (md.y(segments(:,1))-md.y(segments(:,2))).^2 );
%normal(:,1)=cos(atan2( (md.x(segments(:,1))-md.x(segments(:,2))) , (md.y(segments(:,2))-md.y(segments(:,1))) ) );
%normal(:,2)=sin(atan2( (md.x(segments(:,1))-md.x(segments(:,2))) , (md.y(segments(:,2))-md.y(segments(:,1))) ) );

if strcmpi(md.type,'2d'),
	for n=1:size(segments,1),

		plot(md.x(segments(n,1:2)),md.y(segments(n,1:2)),'b-','linewidth',2);
		hold on
		plot(md.x(segments(n,1:2)),md.y(segments(n,1:2)),'r.','markersize',12);

		%xstart=mean(md.x(segments(n,1:2)));
		%ystart=mean(md.y(segments(n,1:2)));

		%xend=xstart+length(n)*normal(n,1);
		%yend=ystart+length(n)*normal(n,2);

		%plot([xstart xend],[ystart yend],'r-')
		legend('element edges on ice front','grids on ice front','normal vectors')
	end
else
	error('plot_segments: 3d plot of segments not supported yet!');
end

%apply options
if isnan(options_structure.title)
	options_structure.title='Segment boundaries';
end 
if isnan(options_structure.colorbar)
	options_structure.colorbar=0;
end
applyoptions(md,[],options_structure);
