function plot_qmuimportancefactors(md,options_structure,width,ii);
%PLOT_IMPORTANCEFACTORS - plot importance factors
%
%   Usage:
%      plot_importancefactors(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%first recover design variable descriptor
if ~isnan(options_structure.designvariable),
	descriptor=options_structure.designvariable;
else
	error('plot_importancefactors error message: Need to supply design variable descriptor');
end
descriptorlength=length(descriptor);

%then recover responsfunction name
if ~isnan(options_structure.responsefunction),
	responsefunctiondescriptor=options_structure.responsefunction;
else
	error('plot_importancefactors error message: Need to supply response function descriptor');
end

%go through all response functions and find the one corresponding to the correct responsefunctiondescriptor
responsefunctions=md.dakotaresults.dresp_out;
found=0;
for i=1:length(responsefunctions),
	if strcmpi(responsefunctions(i).descriptor,responsefunctiondescriptor),
		found=i;
		break;
	end
end
if ~found,
	error('plot_importancefactors error message: could not find correct response function');
end
responsefunctions=responsefunctions(found);
nfun=size(responsefunctions.var,1);

%Now recover response to the correct design variable
importancefactors=zeros(md.npart,1);
count=0;
for i=1:nfun,
	var=responsefunctions.var{i};
	if strncmpi(var,descriptor,descriptorlength),
		count=count+1;
		importancefactors(count)=responsefunctions.impfac(i);
	end
end
if count==0,
	error('plot_importancefactors error message: could not find to response functions with corresponding design variable');
end

%log?
if ~isnan(options_structure.log),
	logvalue=options_structure.log;
	importancefactors=log(importancefactors)/log(logvalue);
end

%Ok, get partitioning.
[epart npart]=MeshPartition(md,md.npart);

%distribute importance factor
gridimportance=importancefactors(npart);

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);

%edgecolor?
if ~isnan(options_structure.edgecolor),
	edgecolor=options_structure.edgecolor;
else
	edgecolor='none';
end

%standard plot:
subplot(width,width,ii);

%ok, plot gridimportance now.
if is2d,
	A=elements(:,1); B=elements(:,2); C=elements(:,3); 
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', gridimportance,'FaceColor','interp','EdgeColor',edgecolor);
else
	error('plot_importancefactors error message: 3d meshes not supported yet');
end

%apply options
applyoptions(md,[],options_structure);
